<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class OptionServiceAndLocations extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $contentTypes = ['services', 'locations'];

        foreach ($contentTypes as $contentType) {
            $bridge->updateContentTypeOptions($contentType, ['categorizable' => true, 'permissible' => true]);
        }
    }

    public function down(): void
    {
    }
}
