<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class AddWeightFolders extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $bridge = new BridgeContentType();

        $weight = 1;

        $bridge->contentTypeCreateOrUpdateField(
            'folders',
            'weight',
            [
                'name' => 'weight',
                'type' => BridgeContentType::INTEGER_FIELD,
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => $weight,
                'title' => [
                    'fr' => 'Poids',
                ],
                'widget' => [
                    'type' => BridgeContentType::NUMBER_WIDGET,
                    'settings' => [],
                    'weight' => $weight++,
                ],
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
            1
        );

        $bridge->contentTypeCreateOrUpdateField(
            'cse_folders',
            'weight',
            [
                'name' => 'weight',
                'type' => BridgeContentType::INTEGER_FIELD,
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => $weight,
                'title' => [
                    'fr' => 'Poids',
                ],
                'widget' => [
                    'type' => BridgeContentType::NUMBER_WIDGET,
                    'settings' => [],
                    'weight' => $weight++,
                ],
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
            1
        );

        $bridge->contentTypeCreateOrUpdateField(
            'groups_folders',
            'weight',
            [
                'name' => 'weight',
                'type' => BridgeContentType::INTEGER_FIELD,
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => $weight,
                'title' => [
                    'fr' => 'Poids',
                ],
                'widget' => [
                    'type' => BridgeContentType::NUMBER_WIDGET,
                    'settings' => [],
                    'weight' => $weight++,
                ],
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
            1
        );
    }

    public function down(): void
    {
    }
}
