<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddDirectLineField extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $field = [
            'name' => 'direct_line',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => false,
            'translatable' => false,
            'editable' => false,
            'search_result_field' => true,
            'required' => false,
            'weight' => 20,
            'title' => [
                'fr' => 'Ligne directe',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'weight' => 20,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ];


        $bridge->contentTypeCreateOrUpdateField('users', 'direct_line', $field);
    }

    public function down(): void
    {
    }
}
