<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddFieldsCommentsToEvents extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $fieldComments = [
            'name' => 'comments',
            'searchable' => false,
            'translatable' => false,
            'default' => [],
            'search_result_field' => false,
            'required' => false,
            'title' => [
                'fr' => 'Commentaires'
            ],
            'description' => [
                'fr' => ''
            ],
            'widget' => [
                'hidden' => true,
            ],
            'type' => BridgeContentType::COMMENT_FIELD,
            'settings' => [
                'comment_type' => 'comments',
                'cardinality' => 1,
            ],
        ];

        $fieldPlace = [
            'name' => 'place',
            'searchable' => true,
            'translatable' => false,
            'default' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 3,
            'title' => [
                'fr' => 'Lieu',
                'de' => 'Lieu',
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 3,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ];

        $bridge->contentTypeCreateOrUpdateField('events', 'comments', $fieldComments);
        $bridge->contentTypeCreateOrUpdateField('events', 'place', $fieldPlace);
    }

    public function down(): void
    {
    }
}
