<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class UpdateFieldsBirthday extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $field =         [
            'name' => 'birthday',
            'type' => BridgeContentType::TIMESTAMP_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'editable' => true,
            'weight' => 10,
            'title' => [
                'fr' => 'Date de naissance',
            ],
            'widget' => [
                'type' => BridgeContentType::TIMESTAMP_WIDGET,
                'weight' => 10,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ];

        $bridge->contentTypeDeleteField('user', 'user', 'date_of_birth');

        $bridge->contentTypeCreateOrUpdateField('users', 'birthday', $field);
    }

    public function down(): void
    {
    }
}
