<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Migrations\CreateContentTypes;

class MakePublicPageSluggable extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $this->getBridge()?->updateContentTypeOptions('public_pages', [
            'name' => 'public_pages',
            'searchable' => true,
            'aliasable' => true,
            'listing_type' => 'content',
        ]);

        $this->finishUp();

        Artisan::call("models:rebuild");
    }

    public function down(): void
    {
        //
    }
}
