<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Facades\ContentBlueprints;
use Inside\Content\Facades\Schema;
use Inside\Host\Migrations\CreateContentTypes;

class ActivateLoginPopinConsentUser extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        if (! Schema::hasModel('popins')) {
            ContentBlueprints::generateContent(contentType: 'popins');
        }

        $this->getBridge()?->updateContentTypeOptions('popins', [
            'name' => 'popins',
            'translatable' => true,
            'title' => [
                'fr' => 'Consentement utilisateur',
                'en' => 'User Consent',
                'es' => 'Consentimiento del usuario',
                'de' => 'Nutzerzustimmung',
                'pt' => 'Consentimento do usuário',
                'nl' => 'Toestemming van de gebruiker',
            ],
        ]);

        $this->getBridge()?->updateContentTypeOptions('public_pages', [
            'name' => 'public_pages',
            'searchable' => true,
            'listing_type' => 'content',
        ]);

        $this->finishUp();

        Artisan::call("models:rebuild");
    }

    public function down(): void
    {
        $this->bootUp(__FILE__);
        $this->getBridge()?->contentTypeDelete('popins');
        $this->finishUp();
    }
}
