<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Migrations\CreateContentTypes;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Facades\Schema;

class AddLangNewsCategoriesListing extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        if (
            ! Schema::hasContentType('news_categories_listings')
        ) {
            return;
        }

        $this->bootUp(__FILE__);

        $bridge = new BridgeContentType();

        $options = Schema::getModelOptions('news_categories');
        $langcodeFieldOptions = Schema::getFieldOptions('news_categories', 'langcode');
        $displayed = $langcodeFieldOptions['displayed'];

        $bridge->changeFieldFormOptions('news_categories_listings', 'langcode', $displayed, 'group_advanced_options');
        $bridge->updateFieldOptions(
            type: 'news_categories',
            fieldName: 'news_categories_listings',
            options: [
                'name' => 'news_categories_listings',
                'required' => false,
            ]
        );

        Artisan::call('models:rebuild');

        $this->finishUp();
    }
}
