<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Host\Bridge\BridgeContentType;

class FixTranslationsIssues extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $allModels = InsideSchema::getContentTypes();

        $authorField = [
            'fr' => 'Auteur',
            'en' => 'Author',
            'es' => 'Autor',
            'nl' => 'Auteur',
            'pt' => 'Autor',
            'de' => 'Autor',
        ];

        $modelsWithAuthorField = InsideSchema::getModelsWithField('authors');

        collect($modelsWithAuthorField)->each(function ($modelWithAuthorField) use ($authorField) {
            InsideSchema::updateFieldOption($modelWithAuthorField, 'authors', 'title', $authorField);
        });

        $contentField = [
            'fr' => 'Contenu',
            'en' => 'Content',
            'es' => 'Contenido',
            'nl' => 'Inhoud',
            'pt' => 'Conteúdo',
            'de' => 'Inhalt',
        ];

        $modelsWithContentField = InsideSchema::getModelsWithField('content');

        collect($modelsWithContentField)->each(function ($modelWithContentField) use ($contentField) {
            InsideSchema::updateFieldOption($modelWithContentField, 'content', 'title', $contentField);
        });

        $types = [
            'blocks' => [
                'fr' => 'Bloc',
                'en' => 'Block',
                'es' => 'Bloque',
                'nl' => 'Blok',
                'pt' => 'Bloco',
                'de' => 'Block',
            ],
            'external_notifications' => [
                'fr' => 'Notification externe',
                'en' => 'External notification',
                'es' => 'Notificación externa',
                'nl' => 'Externe notificatie',
                'pt' => 'Notificação externa',
                'de' => 'Externe Benachrichtigung',
            ],
            'media_viewer' => [
                'fr' => 'Carrousel',
                'en' => 'Carousel',
                'es' => 'Carrusel',
                'nl' => 'Carrousel',
                'pt' => 'Carrossel',
                'de' => 'Karussell',
            ],
            'popins' => [
                'fr' => 'Consentement utilisateur',
                'en' => 'User consent',
                'es' => 'Consentimiento del usuario',
                'nl' => 'Gebruikerstoestemming',
                'pt' => 'Consentimento do utilizador',
                'de' => 'Benutzerzustimmung',
            ],
            'advanced_forms' => [
                'fr' => 'Formulaires avancés',
                'en' => 'Advanced forms',
                'es' => 'Formularios avanzados',
                'nl' => 'Geavanceerde formulieren',
                'pt' => 'Formulários avançados',
                'de' => 'Erweiterte Formulare',
            ],
            'flash_news' => [
                'fr' => 'Flash info',
                'en' => 'Newsflash',
                'es' => 'Boletín informativo',
                'nl' => 'Nieuwsflits',
                'pt' => 'Flash informativo',
                'de' => 'Nachrichten-Flash',
            ],
            'connexion_popups' => [
                'fr' => 'Popin de connexion',
                'en' => 'Login pop-up',
                'es' => 'Ventana emergente de inicio de sesión',
                'nl' => 'Inlogpop-up',
                'pt' => 'Pop-up de login',
                'de' => 'Login-Pop-up',
            ],
            'faq_questions' => [
                'fr' => 'Question FAQ',
                'en' => 'FAQ question',
                'es' => 'Pregunta de FAQ',
                'nl' => 'FAQ-vraag',
                'pt' => 'Pergunta de FAQ',
                'de' => 'FAQ-Frage',
            ],
            'tabs' => [
                'fr' => 'Onglet',
                'en' => 'Tab',
                'es' => 'Pestaña',
                'nl' => 'Tabblad',
                'pt' => 'Aba',
                'de' => 'Registerkarte',
            ],
            'documents' => [
                'fr' => 'Document',
                'en' => 'Document',
                'es' => 'Documento',
                'nl' => 'Document',
                'pt' => 'Documento',
                'de' => 'Dokument',
            ],
            'news' => [
                'fr' => 'Actualité',
                'en' => 'News',
                'es' => 'Actualidad',
                'nl' => 'Nieuws',
                'pt' => 'Notícia',
                'de' => 'Nachrichten',
            ],
            'tools' => [
                'fr' => 'Outil',
                'en' => 'Tool',
                'es' => 'Herramienta',
                'nl' => 'Hulpmiddel',
                'pt' => 'Ferramenta',
                'de' => 'Werkzeug',
            ],
            'events' => [
                'fr' => 'Événement',
                'en' => 'Event',
                'es' => 'Evento',
                'nl' => 'Evenement',
                'pt' => 'Evento',
                'de' => 'Veranstaltung',
            ],
            'custom' => [
                'fr' => 'Page personnalisée',
                'en' => 'Custom page',
                'es' => 'Página personalizada',
                'nl' => 'Aangepaste pagina',
                'pt' => 'Página personalizada',
                'de' => 'Benutzerdefinierte Seite',
            ],
            'events_categories' => [
                'fr' => 'Catégorie d\'événement',
                'en' => 'Event category',
                'es' => 'Categoría de evento',
                'nl' => 'Evenementcategorie',
                'pt' => 'Categoria de evento',
                'de' => 'Veranstaltungskategorie',
            ],
            'tools_categories' => [
                'fr' => 'Catégorie d\'outil',
                'en' => 'Tool category',
                'es' => 'Categoría de herramienta',
                'nl' => 'Gereedschapcategorie',
                'pt' => 'Categoria de ferramenta',
                'de' => 'Werkzeugkategorie',
            ],
            'faq_categories' => [
                'fr' => 'Catégorie FAQ',
                'en' => 'FAQ category',
                'es' => 'Categoría de FAQ',
                'nl' => 'FAQ-categorie',
                'pt' => 'Categoria de FAQ',
                'de' => 'FAQ-Kategorie',
            ],
            'folders' => [
                'fr' => 'Dossier',
                'en' => 'Folder',
                'es' => 'Carpeta',
                'nl' => 'Map',
                'pt' => 'Pasta',
                'de' => 'Ordner',
            ],
            'tools_categories_listings' => [
                'fr' => 'Listing catégorie d\'outils',
                'en' => 'Tool category listing',
                'es' => 'Listado de categoría de herramientas',
                'nl' => 'Gereedschapscategorie lijst',
                'pt' => 'Listagem de categoria de ferramentas',
                'de' => 'Liste der Werkzeugkategorien',
            ],
            'cards_links' => [
                'fr' => 'Image avec lien',
                'en' => 'Image with link',
                'es' => 'Imagen con enlace',
                'nl' => 'Afbeelding met link',
                'pt' => 'Imagem com link',
                'de' => 'Bild mit Link',
            ]
        ];

        foreach ($types as $type => $translations) {
            if (in_array($type, $allModels)) {
                $bridge->changeContentTypeTitle(
                    type: $type,
                    titles: $translations
                );
            }
        }

        $contentTypes = [
            'blocks' => [
                'dark_mode' => [
                    'fr' => 'Mode sombre',
                    'en' => 'Dark mode',
                    'es' => 'Modo oscuro',
                    'nl' => 'Donkere modus',
                    'pt' => 'Modo escuro',
                    'de' => 'Dunkelmodus',
                ],
            ],
            'flash_news' => [
                'icon' => [
                    'fr' => 'Icône',
                    'en' => 'Icon',
                    'es' => 'Icono',
                    'de' => 'Symbol',
                    'pt' => 'Ícone',
                    'nl' => 'Icon',
                ],
                'background_color' => [
                    'fr' => 'Couleur de fond',
                    'en' => 'Background color',
                    'es' => 'Color de fondo',
                    'de' => 'Hintergrundfarbe',
                    'pt' => 'Cor de fundo',
                    'nl' => 'Achtergrondkleur',
                ],
                'dark_mode' => [
                    'fr' => 'Mode sombre',
                    'en' => 'Dark mode',
                    'es' => 'Modo oscuro',
                    'de' => 'Dunkelmodus',
                    'pt' => 'Modo escuro',
                    'nl' => 'Donkere modus',
                ],
                'flash_content' => [
                    'fr' => 'Contenu',
                    'en' => 'Content',
                    'es' => 'Contenido',
                    'de' => 'Inhalt',
                    'pt' => 'Conteúdo',
                    'nl' => 'Inhoud',
                ],
                'end_date' => [
                    'fr' => 'Date de fin',
                    'en' => 'End date',
                    'es' => 'Fecha de fin',
                    'de' => 'Enddatum',
                    'pt' => 'Data de fim',
                    'nl' => 'Einddatum',
                ]
            ],
            'movements' => [
                'movements_categories' => [
                    'fr' => 'Catégorie',
                    'en' => 'Category',
                    'es' => 'Categoría',
                    'de' => 'Kategorie',
                    'pt' => 'Categoria',
                    'nl' => 'Categorie',
                ],
                'movements_description' => [
                    'fr' => 'Description',
                    'en' => 'Description',
                    'es' => 'Descripción',
                    'de' => 'Beschreibung',
                    'pt' => 'Descrição',
                    'nl' => 'Beschrijving',
                ],
                'movements_users' => [
                    'fr' => 'Utilisateur',
                    'en' => 'User',
                    'es' => 'Usuario',
                    'de' => 'Benutzer',
                    'pt' => 'Usuário',
                    'nl' => 'Gebruiker',
                ],
            ],
            'custom' => [
                'introduction' => [
                    'fr' => 'Introduction',
                    'en' => 'Introduction',
                    'es' => 'Introducción',
                    'de' => 'Einleitung',
                    'pt' => 'Introdução',
                    'nl' => 'Introductie',
                ],
                'color' => [
                    'fr' => 'Couleur du titre de la page',
                    'en' => 'Page title color',
                    'es' => 'Color del título de la página',
                    'de' => 'Farbe des Seitentitels',
                    'pt' => 'Cor do título da página',
                    'nl' => 'Kleur van de paginatitel',
                ],
            ],
            'pages' => [
                'banner' => [
                    'fr' => 'Bannière',
                    'en' => 'Banner',
                    'es' => 'Banner',
                    'de' => 'Banner',
                    'pt' => 'Banner',
                    'nl' => 'Banner',
                ],
                'chapo' => [
                    'fr' => 'Introduction',
                    'en' => 'Introduction',
                    'es' => 'Introducción',
                    'de' => 'Einleitung',
                    'pt' => 'Introdução',
                    'nl' => 'Introductie',
                ],
            ],
            'connexion_popups' => [
                'end_date' => [
                    'fr' => 'Date de fin',
                    'en' => 'End date',
                    'es' => 'Fecha de fin',
                    'de' => 'Enddatum',
                    'pt' => 'Data de fim',
                    'nl' => 'Einddatum',
                ]
            ],
            'faq_questions' => [
                'faq_categories' => [
                    'fr' => 'Catégorie FAQ',
                    'en' => 'FAQ Category',
                    'es' => 'Categoría de FAQ',
                    'de' => 'FAQ-Kategorie',
                    'pt' => 'Categoria de FAQ',
                    'nl' => 'FAQ-categorie',
                ],
                'weight' => [
                    'fr' => "Ordre d'affichage",
                    'en' => 'Display order',
                    'es' => 'Orden de visualización',
                    'de' => 'Anzeigereihenfolge',
                    'pt' => 'Ordem de exibição',
                    'nl' => 'Weergavevolgorde',
                ]
            ],
            'tabs_pages' => [
                'tabs' => [
                    'fr' => 'Onglet',
                    'en' => 'Tab',
                    'es' => 'Pestaña',
                    'de' => 'Registerkarte',
                    'pt' => 'Aba',
                    'nl' => 'Tab',
                ]
            ],
            'movements_categories' => [
                'color' => [
                    'fr' => 'Couleur',
                    'en' => 'Color',
                    'es' => 'Color',
                    'de' => 'Farbe',
                    'pt' => 'Cor',
                    'nl' => 'Kleur',
                ],
                'template' => [
                    'fr' => 'Modèle',
                    'en' => 'Template',
                    'es' => 'Modelo',
                    'de' => 'Vorlage',
                    'pt' => 'Modelo',
                    'nl' => 'Sjabloon',
                ],
                'button_text' => [
                    'fr' => 'Texte du bouton',
                    'en' => 'Button text',
                    'es' => 'Texto del botón',
                    'de' => 'Buttontext',
                    'pt' => 'Texto do botão',
                    'nl' => 'Knoptekst',
                ],
            ],
            'faq_categories' => [
                'weight' => [
                    'fr' => "Ordre d'affichage",
                    'en' => 'Display order',
                    'es' => 'Orden de visualización',
                    'de' => 'Anzeigereihenfolge',
                    'pt' => 'Ordem de exibição',
                    'nl' => 'Weergavevolgorde',
                ]
            ],
            'folders' => [
                'is_media_folder' => [
                    'fr' => 'Dossier médiathèque',
                    'en' => 'Media folder',
                    'es' => 'Carpeta de medios',
                    'de' => 'Medienordner',
                    'pt' => 'Pasta de mídia',
                    'nl' => 'Mediamap',
                ]
            ]
        ];

        foreach ($contentTypes as $contentType => $typeName) {
            foreach ($typeName as $fieldName => $fieldTranslations) {
                if (in_array($contentType, $allModels) && InsideSchema::hasField($contentType, $fieldName)) {
                    InsideSchema::updateFieldOption($contentType, $fieldName, 'title', $fieldTranslations);
                }
            }
        }
    }
}
