<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Migrations\CreateContentTypes;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Facades\Schema;

class CreateNewsCategoriesListing extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        if (! Schema::hasContentType('news_categories')) {
            return;
        }

        $this->bootUp(__FILE__);

        $this->migrateContent('news_categories_listings', false);

        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            type: 'news_categories',
            fieldName: 'news_categories_listings',
            options: [
                'name' => 'news_categories_listings',
                'searchable' => true,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => true,
                'weight' => -2,
                'title' => [
                    'fr' => 'Listing catégorie d\'actualités',
                    'en' => 'News categories listing',
                    'es' => 'Listado de categorías de noticias',
                    'pt' => 'Listagem de categorias de notícias',
                    'de' => 'Nachrichtenkategorienliste',
                    'nl' => 'Lijst van nieuwscategorieën',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 1,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['news_categories_listings'],
                    'cardinality' => 1,
                ],
            ],
        );

        $this->finishUp();
    }
}
