<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'news_categories_listings',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => true,
        'permissible' => true,
        'categorizable' => true,
        'listing_type' => 'taxo',
        'title' => [
            'fr' => 'Listing catégorie d\'actualités',
            'en' => 'News categories listing',
            'es' => 'Listado de categorías de noticias',
            'pt' => 'Listagem de categorias de notícias',
            'de' => 'Nachrichtenkategorienliste',
            'nl' => 'Lijst van nieuwscategorieën',
        ],
    ],
    'fields' => [
        [
            'name' => 'introduction',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Introduction',
                'en' => 'Introduction',
                'es' => 'Introducción',
                'pt' => 'Introdução',
                'de' => 'Einführung',
                'nl' => 'Inleiding',
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows' => 5,
                    'placeholder' => '',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'banner',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Bannière',
                'en' => 'Banner',
                'es' => 'Banner',
                'pt' => 'Banner',
                'de' => 'Banner',
                'nl' => 'Banner',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 2,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'color',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 3,
            'title' => [
                'fr' => 'Couleur du titre et de l’introduction',
                'en' => 'Title and introduction color',
                'es' => 'Color del título e introducción',
                'pt' => 'Cor do título e introdução',
                'de' => 'Farbe von Titel und Einführung',
                'nl' => 'Kleur van titel en inleiding',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_COLOR_PICKER_WIDGET,
                'settings' => [],
                'weight' => 3,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'filter_format',
            'searchable' => false,
            'translatable' => true,
            'default' => 'on_the_line',
            'search_result_field' => true,
            'required' => true,
            'weight' => 201,
            'title' => [
                'fr' => 'Format du filtre',
                'nl' => 'Filterformaat',
                'de' => 'Filterformat',
                'es' => 'Formato del filtro',
                'en' => 'Filter format',
                'pt' => 'Formato do filtro',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 201,
            ],
            'type' => BridgeContentType::LIST_STRING_FIELD,
            'settings' => [
                'allowed_values' => [
                    'on_the_line' => [
                        'fr' => 'En ligne',
                        'nl' => 'Online',
                        'de' => 'Online',
                        'es' => 'En línea',
                        'en' => 'Online',
                        'pt' => 'Online',
                    ],
                    'selection' => [
                        'fr' => 'Liste déroulante',
                        'nl' => 'Keuzelijst',
                        'de' => 'Dropdown-Liste',
                        'es' => 'Lista desplegable',
                        'en' => 'Dropdown list',
                        'pt' => 'Lista suspensa',
                    ],
                    'no_filter' => [
                        'fr' => 'Aucun filtre',
                        'nl' => 'Geen filter',
                        'de' => 'Kein Filter',
                        'es' => 'Ningún filtro',
                        'en' => 'No filter',
                        'pt' => 'Sem filtro',
                    ],
                ],
                'allowed_values_function' => '',
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'news_view_mode',
            'searchable' => false,
            'translatable' => true,
            'default' => 'long',
            'search_result_field' => true,
            'required' => true,
            'weight' => 202,
            'title' => [
                'fr' => 'Affichage des news',
                'nl' => 'Nieuwsweergave',
                'de' => 'Nachrichtenanzeige',
                'es' => 'Visualización de noticias',
                'en' => 'News display',
                'pt' => 'Exibição de notícias',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 202,
            ],
            'type' => BridgeContentType::LIST_STRING_FIELD,
            'settings' => [
                'allowed_values' => [
                    'long' => [
                        'fr' => 'Longue',
                        'nl' => 'Lang',
                        'de' => 'Lang',
                        'es' => 'Larga',
                        'en' => 'Long',
                        'pt' => 'Longa',
                    ],
                    'high' => [
                        'fr' => 'Haute',
                        'nl' => 'Hoog',
                        'de' => 'Hoch',
                        'es' => 'Alta',
                        'en' => 'High',
                        'pt' => 'Alta',
                    ],
                    'brief' => [
                        'fr' => 'Brève',
                        'nl' => 'Kort',
                        'de' => 'Kurz',
                        'es' => 'Breve',
                        'en' => 'Brief',
                        'pt' => 'Breve',
                    ],
                ],
                'allowed_values_function' => '',
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'add_search_bar',
            'searchable' => false,
            'translatable' => true,
            'default' => false,
            'search_result_field' => true,
            'required' => false,
            'weight' => 203,
            'title' => [
                'fr' => 'Ajouter une barre de recherche',
                'nl' => 'Een zoekbalk toevoegen',
                'de' => 'Suchleiste hinzufügen',
                'es' => 'Agregar una barra de búsqueda',
                'en' => 'Add a search bar',
                'pt' => 'Adicionar uma barra de pesquisa',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 203,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
    ],
];
