<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;

class FixFieldsDefaultValue extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        collect([
            ['custom', 'introduction', ['default' => '']],
            ['slide_image', 'title', ['default' => ''], 1, 'paragraph'],
            ['slide_image', 'image', ['default' => ''], 2, 'paragraph'],
            ['slide_video', 'title', ['default' => ''], 1, 'paragraph'],
            ['slide_video', 'file', ['default' => ''], 2, 'paragraph'],
        ])->each(fn ($field) => $bridge->contentTypeCreateOrUpdateField(...$field));
    }
}
