<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'news',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => true,
        'permissible' => true,
        'categorizable' => false,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Actualité',
            'en' => 'News',
            'nl' => 'Nieuws',
            'pt' => 'Notícias',
            'es' => 'Noticias',
            'de' => 'Nachrichten',
        ],
    ],
    'fields' => [
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => true,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Image principale',
                'en' => 'Main picture',
                'nl' => 'Hoofdafbeelding',
                'pt' => 'Imagem principal',
                'es' => 'imagen principal',
                'de' => 'Hauptbild',
            ],
            'description' => [
                'fr' => 'Cette image remonte sur les listings des actualités ainsi que dans l\'actualité. Si vous souhaitez ne pas l\'afficher dans le corps de l\'actualité rendez-vous dans les paramètres avancés',
                'en' => 'This image appears on news listings as well as in the news. If you do not want to display it in the body of the news, go to the advanced settings',
                'nl' => 'Deze afbeelding verschijnt zowel op nieuwsoverzichten als in het nieuws. Als je het niet in de hoofdtekst van het nieuws wilt weergeven, ga dan naar de geavanceerde instellingen',
                'pt' => 'Esta imagem aparece nas listas de notícias e também nas notícias. Caso não queira exibi-la no corpo da notícia, acesse as configurações avançadas',
                'es' => 'Esta imagen aparece tanto en las listas de noticias como en las noticias. Si no quieres que aparezca en el cuerpo de la noticia, ve a configuración avanzada',
                'de' => 'Dieses Bild erscheint sowohl in Nachrichtenlisten als auch in den Nachrichten. Wenn Sie es nicht im Nachrichtentext anzeigen möchten, gehen Sie zu den erweiterten Einstellungen',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 0,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'chapo',
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => true,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 1,
            'title' => [
                'fr' => 'Introduction',
                'en' => 'Introduction',
                'nl' => 'Invoering',
                'pt' => 'Introdução',
                'es' => 'Introducción',
                'de' => 'Einführung',
            ],
            'description' => [
                'fr' => 'L\'introduction remonte sur les pages de listing d\'actualité et n\'est pas dupliquée dans votre contenu',
                'en' => 'The introduction goes up on the news listing pages and is not duplicated in your content',
                'nl' => 'De introductie wordt weergegeven op de nieuwspagina\'s en wordt niet gedupliceerd in uw inhoud',
                'pt' => 'A introdução vai para as páginas de listagem de notícias e não é duplicada no seu conteúdo',
                'es' => 'La introducción sube en las páginas de listado de noticias y no se duplica en su contenido.',
                'de' => 'Die Einführung erscheint auf den Seiten der Nachrichtenliste und wird nicht in Ihren Inhalten dupliziert',
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows' => 5,
                    'placeholder' => '',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'content',
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 2,
            'title' => [
                'fr' => 'Contenu',
                'en' => 'Content',
                'nl' => 'Inhoud',
                'pt' => 'Conteúdo',
                'es' => 'Contenido',
                'de' => 'Inhalt',
            ],
            'description' => [
                'fr' => 'Sélectionnez les différents types de paragraphes que vous voulez faire remonter sur la page',
                'en' => 'Select the different types of paragraphs you want to move up the page',
                'nl' => 'Selecteer de verschillende soorten alinea\'s die u naar boven op de pagina wilt verplaatsen',
                'pt' => 'Seleccione os diferentes tipos de parágrafos que deseja mover para cima da página',
                'es' => 'Seleccione los diferentes tipos de párrafos que desea mover hacia arriba en la página',
                'de' => 'Wählen Sie die verschiedenen Arten von Absätzen aus, die Sie auf der Seite nach oben verschieben möchten',
            ],
            'widget' => [
                'type' => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title' => 'Paragraphe',
                    'title_plural' => 'Paragraphes',
                    'edit_mode' => 'open',
                    'add_mode' => 'dropdown',
                    'form_display_mode' => 'default',
                    'default_paragraph_type' => '',
                ],
                'weight' => 2,
            ],
            'type' => BridgeContentType::SECTION_FIELD,
            'settings' => [
                'target_type' => [
                    'text',
                    'text_two_columns',
                    'text_with_image',
                    'separator',
                    'file',
                    'slider',
                    'image',
                    'video',
                    'map',
                    'accordion',
                    'call_to_action',
                    'button',
                    'html',
                    'tweet',
                    'fetched_contents',
                ],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'news_categories',
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => true,
            'searchable_filter' => true,
            'required' => true,
            'weight' => 3,
            'title' => [
                'fr' => 'Catégorie(s) de l\'actualité',
                'en' => 'News category(ies)',
                'nl' => 'Nieuwscategorie(ën)',
                'pt' => 'Categoria(s) da(s) notícia(s)',
                'es' => 'Categoría(s) de noticias',
                'de' => 'News-Kategorie(n)',
            ],
            'description' => [
                'fr' => 'Sélectionnez la ou les catégorie de cette actualité',
                'en' => 'Sélectionnez la ou les catégorie de cette actualité',
                'nl' => 'Selecteer de categorie(ën) van dit nieuws',
                'pt' => 'Seleccione a(s) categoria(s) desta notícia',
                'es' => 'Sélectionnez la ou les catégorie de cette actualité',
                'de' => 'Sélectionnez la ou les catégorie de cette actualité',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 3,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['news_categories'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ],
        [
            'name' => 'is_featured',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 4,
            'title' => [
                'fr' => 'À la une',
                'en' => 'Featured',
                'nl' => 'Uitgelicht',
                'pt' => 'Manchetes',
                'es' => 'Presentado',
                'de' => 'Hervorgehoben',
            ],
            'description' => [
                'fr' => 'Faites remonter l\'actualité à la une sur la page d\'accueil',
                'en' => 'Bring headline news to the homepage',
                'nl' => 'Breng het nieuws naar de voorpagina op de startpagina',
                'pt' => 'Trazer as notícias para a primeira página',
                'es' => 'Llevar noticias de primera plana a la página de inicio',
                'de' => 'Bringen Sie Schlagzeilen auf die Homepage',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 4,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => false,
        ],
        [
            'name' => 'comments',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 5,
            'title' => [
                'fr' => 'Commentaires',
                'en' => 'Comments',
                'nl' => 'Opmerkingen',
                'pt' => 'Comentários',
                'es' => 'Comentarios',
                'de' => 'Kommentare',
            ],
            'widget' => [
                'hidden' => true,
            ],
            'type' => BridgeContentType::COMMENT_FIELD,
            'settings' => [
                'comment_type' => 'comments',
                'cardinality' => 1,
            ],
        ],
    ],
];
