import SpacesPage from '../pages/spaces/SpacesPage'
import SpacesPagesPage from '../pages/spaces/SpacesPagesPage'
import {
  fetchSpacesPage,
  fetchSpacesPagesPage
} from '../components/spaces/fetch'

import TabSpacesPage from '../pages/tab-spaces/TabSpacesPage'
import { fetchTabSpacesPage } from '../components/tab-spaces/fetch'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    props: {
      extraCategoriesFields: [
        {
          countries: {
            fields: ['uuid', 'title'],
            filters: { 'status:eq': 1, sort: 'title:asc' }
          }
        }
      ]
    },
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false, content: 'news' }
  },
  {
    name: 'NewsSpeakListingPage',
    path: '/news-speak',
    component: () => import('../pages/news-speak/NewsSpeakListingPage')
  },
  {
    name: 'NewsSpeakPage',
    path: '/news-speak/:slug',
    component: () => import('../pages/news-speak/NewsSpeakPage'),
    meta: { content: 'news_speak' }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false },
    component: () => import('../pages/events/EventsCalendarPage')
  },
  {
    name: 'EventPage',
    meta: { disabled: false, content: 'events' }
  },
  {
    name: 'EventSubscriptionPage',
    meta: { disabled: false }
  },
  {
    name: 'SpacesPage',
    path: '/espace/:slug',
    component: withFetch(SpacesPage, { size: 'xxl' })(fetchSpacesPage),
    meta: { content: 'spaces' }
  },
  {
    name: 'SpacesPagesPage',
    path: {
      fr: '/espace/pages/:slug',
      en: '/space/pages/:slug',
      es: '/espacio/paginas/:slug'
    },
    alias: [
      '/fr/espace/:slug/pages',
      '/en/space/:slug/pages',
      '/es/espacio/:slug/paginas'
    ],
    component: withFetch(SpacesPagesPage, { size: 'xxl' })(
      fetchSpacesPagesPage
    ),
    meta: { content: 'spaces' }
  },
  {
    name: 'TabSpacesPage',
    path: {
      fr: '/espaces-onglet/pages/:slug',
      en: '/tabs-spaces/pages/:slug',
      es: '/espacios-tabulacion/paginas/:slug'
    },
    alias: [
      '/fr/espaces-onglet/:slug/pages',
      '/en/tabs-spaces/:slug/pages',
      '/es/espacios-tabulacion/:slug/paginas'
    ],
    component: withFetch(TabSpacesPage, { size: 'xxl' })(fetchTabSpacesPage),
    meta: { content: 'tab_spaces' }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/directory/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      gridMinMax: '250',
      cardSize: 's',
      cardOverlayEnabled: false
    }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false, content: 'pages' }
  }
]
