import { http } from '@inside-library/helpers/Http'

export default {
  newsSpeak: {
    add: ({ data }) => ({
      name: 'NewsSpeakPage',
      params: { slug: data.slug[0] }
    }),
    delete: ({ data }) => ({
      name: 'NewsSpeakPage',
      params: { slug: data.slug[0] }
    })
  },
  speakCategories: {
    add: () => ({
      name: 'NewsSpeakListingPage'
    }),
    delete: () => ({
      name: 'NewsSpeakListingPage'
    })
  },
  spaces: {
    add: ({ data }) => ({
      name: 'SpacesPage',
      params: { slug: data.slug[0] }
    })
  },
  spacesPages: {
    fields: ['uuid', { pages_categories: [{ spaces: ['slug'] }] }],
    add: ({ data }) => ({
      name: 'SpacesPagesPage',
      params: {
        slug: data.pages_categories.spaces.slug[0]
      },
      query: { page: data.uuid }
    }),
    delete: ({ data }) => ({
      name: 'SpacesPagesPage',
      params: {
        slug: data.pages_categories.spaces.slug[0]
      }
    }),
    globalSearch: async ({ data }) => {
      const { data: pagesCategorie } = await http.get('content/spaces_pages', {
        fields: ['uuid', { pages_categories: ['uuid', 'title'] }],
        filters: { 'uuid:eq': data.uuid }
      })

      const { data: space } = await http.get('content/pages_categories', {
        fields: ['uuid', { spaces: ['uuid', 'title', 'slug'] }],
        filters: { 'uuid:eq': pagesCategorie[0].pages_categories.uuid }
      })

      return {
        route: {
          name: 'SpacesPagesPage',
          params: {
            slug: space[0].spaces.slug[0]
          },
          query: { page: data.uuid }
        }
      }
    }
  },
  pagesCategories: {
    fields: [{ spaces: ['slug'] }],
    add: ({ data }) => ({
      name: 'SpacesPagesPage',
      params: { slug: data.spaces.slug[0] }
    }),
    delete: ({ data }) => ({
      name: 'SpacesPagesPage',
      params: { slug: data.spaces.slug[0] }
    }),
    globalSearch: () => ({
      routeAs: 'add'
    })
  },
  tabSpaces: {
    add: ({ data }) => ({
      name: 'TabSpacesPage',
      params: { slug: data.slug[0] }
    })
  },
  tabSpacesPages: {
    fields: ['uuid', { tab_pages_categories: [{ tab_spaces: ['slug'] }] }],
    add: ({ data }) => ({
      name: 'TabSpacesPage',
      params: { slug: data.tab_pages_categories.tab_spaces.slug[0] },
      query: { page: data.uuid }
    }),
    delete: ({ data }) => ({
      name: 'TabSpacesPage',
      params: { slug: data.tab_pages_categories.tab_spaces.slug[0] }
    })
  },
  tabPagesCategories: {
    fields: [{ tab_spaces: ['slug'] }],
    add: ({ data }) => ({
      name: 'TabSpacesPage',
      params: { slug: data.tab_spaces.slug[0] }
    }),
    delete: ({ data }) => ({
      name: 'TabSpacesPage',
      params: { slug: data.tab_spaces.slug[0] }
    })
  }
}
