import { spacePagesCategoriesFilters } from '../constants'

export const getPagesCategoriesFilters = slug => ({
  ...spacePagesCategoriesFilters,
  spaces: { 'slug:eq': slug }
})

export const newsScaffoldOverrides = (fields, { deleteItems }) => {
  deleteItems('date')
}

export const newsCategories = {
  news_speak_categories: {
    data: (data, contentType, { getData }) => getData(data, contentType),
    disabledOn: ['NewsSpeakListingPage'],
    href: item => ({
      name: 'NewsSpeakListingPage',
      query: { news_speak_categories: item.uuid }
    })
  }
}
