import { insertIf } from '@inside-library/helpers/Arrays'

export default {
  'inside-comments': {
    mentionsEnabled: true
  },
  'inside-commons': {
    banner: {
      useEmptyBanner: true
    }
  },
  'inside-layouts': {
    templates: {
      fullContent: {
        newsSpeak: {
          mainComponent: () => import('@inside-news/components/lib/Full'),
          mainFields: ({ hasContentType }) => [
            'content',
            'image',
            'chapo',
            ...insertIf(hasContentType('news_speak_categories'), {
              news_speak_categories: {
                fields: ['uuid', 'title', 'content_type', 'color'],
                filters: { 'status:eq': 1 }
              }
            })
          ],
          relatedComponent: () => import('@inside-news/components/lib/Minimal'),
          relatedFields: ({ hasContentType }) => [
            'image',
            'chapo',
            ...insertIf(hasContentType('news_speak_categories'), {
              news_speak_categories: {
                fields: ['uuid', 'title', 'content_type', 'color'],
                filters: { 'status:eq': 1 }
              }
            })
          ],
          relatedRedirectionPage: 'NewsSpeakPage'
        }
      }
    }
  },
  'inside-events': {
    subscriptionEnabled: true
  },
  'inside-statistics': {
    contentsWithStats: ['news', 'events', 'documents', 'users']
  },
  'inside-users': {
    shortcuts: {
      max: 5
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'notifications', restrictions: [], icon: 'settings' },
        { name: 'bookmarks', restrictions: [], icon: 'bookmark' },
        { name: 'shortcuts', restrictions: [], icon: 'news' }
      ]
    },
    paragraphs: {
      fetchedContents: {
        display: () => import('./components/users/UserCard'),
        selectionConfig: {
          fields: [
            'uuid_host',
            'firstname',
            'lastname',
            'mobile',
            'function',
            'image',
            { localisation: ['uuid', 'title'] }
          ],
          filters: {
            'status:eq': 1,
            sort: 'lastname:asc',
            'is_maintenance:eq': 0
          }
        },
        requestFields: [
          'uuid',
          'firstname',
          'lastname',
          'mobile',
          'function',
          'image',
          { localisation: ['uuid', 'title'] }
        ]
      }
    }
  }
}
