<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Bridge\BridgeContent;

class FixBlockContentType extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('images_blocks');
        $this->finishUp();

        $bridge = new BridgeContentType();
        $bridgeContent = new BridgeContent();

        type_to_class('blocks')::all()->each(
            fn ($block) => $bridgeContent->contentDelete(
                type: 'blocks',
                uuid: $block->uuid,
            )
        );

        $bridge->contentTypeDelete(
            type: 'blocks'
        );
    }
}
