<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\EmployeeId;
use Inside\Host\Bridge\BridgeContent;

class CreateEmployeeIdTranslations extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();

        EmployeeId::query()->where('langcode', 'fr')->each(function ($id) use ($bridge) {
            foreach (list_languages() as $language) {
                if ($language === 'fr') {
                    continue;
                }
                $bridge->contentInsert('employee_id', [
                    'type' => 'node',
                    'bundle', 'employee_id',
                    'title' => $id->title,
                    'langcode' => $language,
                    'uuid_host' => $id->uuid_host
                ]);
            }
        });
    }
}
