<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class RefactoFieldEvents extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('node', 'events', 'number_place');
        $bridge->contentTypeCreateOrUpdateField('events', 'participants_number', [
            'name' => 'participants_number',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 5,
            'title' => [
                'fr' => 'Place dispo (pour la décrémentation auto)',
                'en' => 'Available space (for auto decrementing)',
                'de' => 'Verfügbarer Platz (für die automatische Dekrementierung)',
                'es' => 'Espacio disponible (para el autodescenso)',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => 5,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ]);
    }

    public function down(): void
    {
    }
}
