<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'pages_categories',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => false,
        'permissible' => false,
        'categorizable' => true,
        'listing_type' => 'taxo',
        'title' => [
            'fr' => 'Regroupement de page RH',
            'en' => 'HR page grouping',
            'de' => 'Gruppierung von HR-Seiten',
            'es' => 'Agrupación de páginas de RRHH',
        ],
    ],
    'fields' => [
        [
            'name' => 'icon',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Icon',
                'en' => 'Icon',
                'de' => 'Icon',
                'es' => 'Icono',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_ICON_PICKER_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 1,
            'title' => [
                'fr' => 'Image',
                'en' => 'Image',
                'de' => 'Bild',
                'es' => 'Imagen',
            ],
            'description' => [
                'fr' => 'Cette image remontera comme une bannière du bloc',
                'en' => 'This image will go up as a banner of the block',
                'de' => 'Dieses Bild wird als Banner des Blocks nach oben wandern',
                'es' => 'Esta imagen aparecerá como un banner en el',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'spaces',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 2,
            'title' => [
                'fr' => 'Espace',
                'en' => 'Space',
                'de' => 'Raum',
                'es' => 'Espacio',
            ],
            'description' => [
                'fr' => 'Choix de l\'espace dans laquelle le regroupement doit remonter',
                'en' => 'Choice of the space in which the grouping should go up',
                'de' => 'Wahl des Raumes, in dem die Gruppierung aufsteigen soll',
                'es' => 'Elección del espacio en el que va a subir la agrupación',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 2,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['spaces'],
                'cardinality' => 1,
            ],
        ],
    ],
];
