<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'flash_news',
        'translatable' => true,
        'searchable' => false,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => true,
        'categorizable' => false,
        'listing_type' => 'hidden',
        'title' => [
            'fr' => 'Flash info',
            'en' => 'News flash',
            'de' => 'Kurznachrichten',
            'es' => 'Noticias',
        ],
    ],
    'fields' => [
        [
            'name' => 'icon',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Icone',
                'en' => 'Icon',
                'de' => 'Ikone',
                'es' => 'Icono',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_ICON_PICKER_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'flash_content',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Contenu',
                'en' => 'Content',
                'de' => 'Inhalt',
                'es' => 'Contenido',
            ],
            'widget' => [
                'type' => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::WYSIWYG_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'end_date',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Date de fin',
                'en' => 'End date',
                'de' => 'Datum des Endes',
                'es' => 'Fecha de fin',
            ],
            'description' => [
                'fr' => 'Choix de la date et heure de dépublication du flash info',
                'en' => 'Choice of the date and time of publication of the news flash',
                'de' => 'Auswahl des Datums und der Uhrzeit für die Veröffentlichung der Eilmeldung',
                'es' => 'Elección de la fecha y hora de publicación de la noticia',
            ],
            'widget' => [
                'type' => BridgeContentType::TIMESTAMP_WIDGET,
                'settings' => [],
                'weight' => 2,
            ],
            'type' => BridgeContentType::TIMESTAMP_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
    ],
];
