<?php

return [
    'postfilter' => fn ($users) => $users->filter(fn ($user) => str($user->employeeId)->contains(['FR01', 'ES01', 'BE01', 'UA01', 'MA01', 'EXTBE', 'EXTUA'])),
    'sync_attributes' => [
        'mail' => 'mail',
        'name' => 'mail',
        'mobile' => 'mobilePhone',
        'phone' => 'telephoneNumber',
        'function' => 'jobTitle',
        'lastname' => 'surname',
        'firstname' => 'givenName',
        'employee_id' => fn (mixed $user) => reference('employee_id')->from(
            match (str($user->employeeId)->startsWith('EXTBE') ||
            str($user->employeeId)->startsWith('EXTUA')) {
                true => str($user->employeeId)->substr(0, 5)->toString(),
                default => str($user->employeeId)->substr(0, 4)->toString(),
            }
        )->get(),
        'localisation' => fn (mixed $user) => reference('localisation')->from($user->officeLocation)->get(),
        'langcode' => fn (mixed $user) => !empty($user->usageLocation) && str($user->usageLocation)->contains(['es', 'de', 'en', 'fr']) ? str($user->usageLocation)->lower()->toString() : 'fr',
        'status' => fn () => true,
        'upn' => 'userPrincipalName',
        'manager' => fn (mixed $user) => reference('users')->identifiedBy('email')->from($user->manager)->withoutCreation()->first(),
    ],
    'custom_attributes' => [
        'manager' => 'mail'
    ]
];
