<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Bridge\BridgeContent;

class UpdateIsFeaturedField extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        $bridgeContent = new BridgeContent();

        $bridge->changeFieldFormOptions(
            type: 'news',
            fieldName: 'is_featured',
            displayed: false,
            group: null
        );

        type_to_class('blocks')::all()->each(
            fn ($block) => $bridgeContent->contentUpdate(
                type: 'blocks',
                data: [
                    'uuid' => $block->uuid,
                    'is_featured' => true
                ],
                fromCli: true,
            )
        );
    }
}
