<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddWeightFieldsToSpacesPages extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        collect(['spaces_pages', 'tab_spaces_pages'])
            ->each(
                fn (string $type) => $bridge->contentTypeCreateOrUpdateField(
                    $type,
                    'weight',
                    [
                        'name' => 'weight',
                        'searchable' => false,
                        'translatable' => true,
                        'search_result_field' => false,
                        'searchable_filter' => false,
                        'required' => false,
                        'weight' => 6,
                        'title' => [
                            'fr' => 'Ordre d\'affichage',
                            'en' => 'Order of appearance',
                            'de' => 'Reihenfolge des Erscheinens',
                            'es' => 'Orden de aparición',
                        ],
                        'description' => [
                            'fr' => 'Le chiffre le plus bas remonte en 1er',
                            'en' => 'The lowest number goes up in 1st',
                            'de' => 'Die niedrigste Zahl steigt in der 1.',
                            'es' => 'El número más bajo sube al 1º',
                        ],
                        'widget' => [
                            'type' => BridgeContentType::NUMBER_WIDGET,
                            'settings' => [],
                            'weight' => 6,
                        ],
                        'type' => BridgeContentType::INTEGER_FIELD,
                        'settings' => [
                            'cardinality' => 1,
                        ],
                        'default' => 0,
                    ],
                    6
                )
            );
    }
}
