<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class CreateEmployeeIdField extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $bridge = new BridgeContentType();

        $this->bootUp(__FILE__);
        $this->migrateContent('employee_id');
        $this->finishUp();
        $bridge->contentTypeCreateOrUpdateField('users', 'employee_id', [
            'name' => 'employee_id',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 3,
            'title' => [
                'fr' => 'Employee id',
                'en' => 'Employee id',
                'de' => 'Employee id',
                'es' => 'Employee id',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 3,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['employee_id'],
                'cardinality' => 1,
            ],
            'selectable_all' => true,
        ]);
    }

    public function down(): void
    {
    }
}
