<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Facades\Schema as InsideSchema;

class TranslateContentTypeAndFields extends Migration
{
    public function up(): void
    {
        $bridgeType = new BridgeContentType();

        $contentTypes = [
            'blocks' => [
                'title' => [
                    'fr' => 'Bloc Homepage',
                    'en' => 'Homepage block',
                    'de' => 'Bloc Homepage',
                    'es' => 'Bloque de la página web',
                ],
            ],
            'countries' => [
                'title' => [
                    'fr' => 'Pays',
                    'en' => 'Country',
                    'de' => 'Land',
                    'es' => 'País',
                ],
            ],
            'custom' => [
                'title' => [
                    'fr' => 'Page personnalisée',
                    'en' => 'Customized page',
                    'de' => 'Benutzerdefinierte Seite',
                    'es' => 'Página personalizada',
                ],
            ],
            'dms_link' => [
                'title' => [
                    'fr' => 'Lien',
                    'en' => 'Link',
                    'de' => 'Link',
                    'es' => 'Enlace',
                ],
            ],
            'documents' => [
                'title' => [
                    'fr' => 'Document',
                    'en' => 'Document',
                    'de' => 'Dokument',
                    'es' => 'Documento',
                ],
            ],
            'events' => [
                'title' => [
                    'fr' => 'Événement',
                    'en' => 'Event',
                    'de' => 'Veranstaltung',
                    'es' => 'Evento',
                ],
            ],
            'events_categories' => [
                'title' => [
                    'fr' => 'Catégorie de l\'événement',
                    'en' => 'Event category',
                    'de' => 'Kategorie der Veranstaltung',
                    'se' => 'Categoría del evento',
                ],
            ],
            'flash_news' => [
                'title' => [
                    'fr' => 'Flash info',
                    'en' => 'News flash',
                    'de' => 'Kurznachrichten',
                    'es' => 'Noticias',
                ],
            ],
            'folders' => [
                'title' => [
                    'fr' => 'Dossier',
                    'en' => 'Folder',
                    'de' => 'Ordner',
                    'es' => 'Archivo',
                ],
            ],
            'localisation' => [
                'title' => [
                    'fr' => 'Localisation',
                    'en' => 'Location',
                    'de' => 'Lokalisierung',
                    'es' => 'Ubicación',
                ],
            ],
            'news_categories' => [
                'title' => [
                    'fr' => 'Catégorie de l\'actualité',
                    'en' => 'Category of news',
                    'de' => 'Kategorie der Nachrichten',
                    'es' => 'Categoría de noticias',
                ],
            ],
            'news_speak' => [
                'title' => [
                    'fr' => 'On parle de nous',
                    'en' => 'We\'re talking about us',
                    'de' => 'Man spricht über uns',
                    'es' => 'Se habla de nosotros',
                ],
            ],
            'news_speak_categories' => [
                'title' => [
                    'fr' => 'Catégorie on parle de nous',
                    'en' => 'Category we are talking about',
                    'de' => 'Kategorie man spricht über uns',
                    'es' => 'Categoría de la que hablamos',
                ],
            ],
            'pages' => [
                'title' => [
                    'fr' => 'Page simple',
                    'en' => 'Single page',
                    'de' => 'Einfache Seite',
                    'es' => 'Una sola página',
                ],
            ],
            'pages_categories' => [
                'title' => [
                    'fr' => 'Regroupement de page RH',
                    'en' => 'HR page grouping',
                    'de' => 'Gruppierung von HR-Seiten',
                    'es' => 'Agrupación de páginas de RRHH',
                ],
            ],
            'spaces' => [
                'title' => [
                    'fr' => 'Espace RH',
                    'en' => 'Space RH',
                    'de' => 'HR-Bereich',
                    'es' => 'Espacio RRHH',
                ],
            ],
            'spaces_pages' => [
                'title' => [
                    'fr' => 'Page RH',
                    'en' => 'HR page',
                    'de' => 'HR-Seite',
                    'es' => 'Página de RRHH',
                ],
            ],
            'tab_pages_categories' => [
                'title' => [
                    'fr' => 'Regroupement de page',
                    'en' => 'Page grouping',
                    'de' => 'Seitengruppierung',
                    'es' => 'Agrupación de páginas',
                ],
            ],
            'tab_spaces' => [
                'title' => [
                    'fr' => 'Espaces',
                    'en' => 'Spaces',
                    'de' => 'Räume',
                    'es' => 'Espacios',
                ],
            ],
            'tab_spaces_pages' => [
                'title' => [
                    'fr' => 'Page',
                    'en' => 'Page',
                    'de' => 'Seite',
                    'es' => 'Página',
                ],
            ],
            'tools' => [
                'title' => [
                    'fr' => 'Outil',
                    'en' => 'Tool',
                    'de' => 'Werkzeug',
                    'es' => 'Herramientas',
                ],
            ],
            'tools_categories' => [
                'title' => [
                    'fr' => 'Catégorie d\'outil',
                    'en' => 'Tool category',
                    'de' => 'Kategorie des Werkzeugs',
                    'es' => 'Categoría de herramientas',
                ],
            ],
            'users' => [
                'title' => [
                    'fr' => 'Utilisateur',
                    'en' => 'User',
                    'de' => 'Benutzer',
                    'es' => 'Usuario',
                ],
            ],
        ];

        $translation = [
            'Image' => [
                'fr' => 'Image',
                'en' => 'Image',
                'de' => 'Bild',
                'es' => 'Imagen',
            ],
            'Date de début' => [
                'fr' => 'Date de début',
                'en' => 'Start date',
                'de' => 'Datum des Beginns',
                'es' => 'Fecha de inicio',
            ],
            'Date de fin' => [
                'fr' => 'Date de fin',
                'en' => 'End date',
                'de' => 'Datum des Endes',
                'es' => 'Fecha de fin',
            ],
            'Afficher les heures' => [
                'fr' => 'Afficher les heures',
                'en' => 'Display hours',
                'de' => 'Zeiten anzeigen',
                'es' => 'Mostrar horas',
            ],
            'Lieu' => [
                'fr' => 'Lieu',
                'en' => 'Place',
                'de' => 'Ort',
                'es' => 'Lugar',
            ],
            'Place dispo (pour la décrémentation auto)' => [
                'fr' => 'Place dispo (pour la décrémentation auto)',
                'en' => 'Available space (for auto decrementing)',
                'de' => 'Verfügbarer Platz (für die automatische Dekrementierung)',
                'es' => 'Espacio disponible (para el autodescenso)',
            ],
            'Catégorie(s) de l\'événement' => [
                'fr' => 'Catégorie(s) de l\'événement',
                'en' => 'Event category',
                'de' => 'Kategorie der Veranstaltung',
                'se' => 'Categoría del evento',
            ],
            'Pays' => [
                'fr' => 'Pays',
                'en' => 'Country',
                'de' => 'Land',
                'es' => 'País',
            ],
            'Commentaires' => [
                'fr' => 'Commentaires',
                'en' => 'Comments',
                'de' => 'Kommentare',
                'es' => 'Comentarios',
            ],
            'Icon' => [
                'fr' => 'Icone',
                'en' => 'Icon',
                'de' => 'Icon',
                'es' => 'Icono',
            ],
            'Couleur de fond' => [
                'fr' => 'Couleur de fond',
                'en' => 'Background color',
                'de' => 'Hintergrundfarbe',
                'es' => 'Color de fondo',
            ],
            'Mode sombre' => [
                'fr' => 'Mode sombre',
                'en' => 'Dark mode',
                'de' => 'Dunkler Modus',
                'es' => 'Modo oscuro',
            ],
            'Lien' => [
                'fr' => 'Lien',
                'en' => 'Link',
                'de' => 'Link',
                'es' => 'Enlace',
            ],
            'Texte du lien' => [
                'fr' => 'Texte du lien',
                'en' => 'Text of the link',
                'de' => 'Text des Links',
                'es' => 'Texto del enlace',
            ],
            'Ordre d\'affichage' => [
                'fr' => 'Ordre d\'affichage',
                'en' => 'Display order',
                'de' => 'Reihenfolge der Anzeige',
                'es' => 'Orden de visualización',
            ],
            'Bannière' => [
                'fr' => 'Bannière',
                'en' => 'Banner',
                'de' => 'Banner',
                'es' => 'Banner',
            ],
            'Introduction' => [
                'fr' => 'Introduction',
                'en' => 'Introduction',
                'de' => 'Einführung',
                'es' => 'Introducción',
            ],
            'Page de redirection' => [
                'fr' => 'Page de redirection',
                'en' => 'Redirection page',
                'de' => 'Weiterleitungsseite',
                'es' => 'Página de redireccionamiento',
            ],
            'Image de prévisualisation' => [
                'fr' => 'Image de prévisualisation',
                'en' => 'Preview image',
                'de' => 'Vorschaubild',
                'es' => 'Vista previa de la imagen',
            ],
            'Fichier' => [
                'fr' => 'Fichier',
                'en' => 'File',
                'de' => 'Datei',
                'es' => 'Archivo',
            ],
            'Contenu' => [
                'fr' => 'Contenu',
                'en' => 'Content',
                'de' => 'Inhalt',
                'es' => 'Contenido',
            ],
            'Dossier parent' => [
                'fr' => 'Dossier parent',
                'en' => 'Parent file',
                'de' => 'Elternordner',
                'es' => 'Archivo principal',
            ],
            'Couleur' => [
                'fr' => 'Couleur',
                'en' => 'Color',
                'de' => 'Farbe',
                'es' => 'Color',
            ],
            'Dossier médiathèque' => [
                'fr' => 'Dossier médiathèque',
                'en' => 'Dossier médiathèque',
                'de' => 'Mediathekordner',
                'es' => 'Archivo de la mediateca',
            ],
            'Événement' => [
                'fr' => 'Événement',
                'en' => 'Event',
                'de' => 'Veranstaltung',
                'es' => 'Evento',
            ],
            'À la une' => [
                'fr' => 'À la une',
                'en' => 'In the spotlight',
                'de' => 'Schlagzeilen',
                'es' => 'En el punto de mira',
            ],
            'Catégorie(s) de l\'actualité' => [
                'fr' => 'Catégorie(s) de l\'actualité',
                'en' => 'Category(ies) of news',
                'de' => 'Kategorie(n) der Nachrichten',
                'es' => 'Categoría(s) de noticias',
            ],
            'Image principale' => [
                'fr' => 'Image principale',
                'en' => 'Main image',
                'de' => 'Hauptbild',
                'es' => 'Imagen principal',
            ],
            'Catégorie On parle de nous' => [
                'fr' => 'Catégorie On parle de nous',
                'en' => 'Category We\'re talking about us',
                'de' => 'Kategorie Über uns wird gesprochen',
                'es' => 'Categoría Hablamos de nosotros',
            ],
            'Espace' =>   [
                'fr' => 'Espace',
                'en' => 'Space',
                'de' => 'Raum',
                'es' => 'Espacio',
            ],
            'Présentation' =>   [
                'fr' => 'Présentation',
                'en' => 'Presentation',
                'de' => 'Präsentation',
                'es' => 'Presentación',
            ],
            'Contacts clés' =>   [
                'fr' => 'Contacts clés',
                'en' => 'Key contacts',
                'de' => 'Schlüsselkontakte',
                'es' => 'Contactos clave',
            ],
            'Outils' =>   [
                'fr' => 'Outils',
                'en' => 'Tools',
                'de' => 'Werkzeug',
                'es' => 'Herramientas',
            ],
            'Documents rh' =>   [
                'fr' => 'Documents rh',
                'en' => 'HR Documents',
                'de' => 'Rh-Dokumente',
                'es' => 'Documentos de RRHH',
            ],
            'Regroupement de page' =>   [
                'fr' => 'Regroupement de page',
                'en' => 'Page grouping',
                'de' => 'Seitengruppierung',
                'es' => 'Agrupación de páginas',
            ],
            'Documents' =>   [
                'fr' => 'Documents',
                'en' => 'Documents',
                'de' => 'Dokumente',
                'es' => 'Documentos',
            ],
            'Catégorie d\'outil' =>   [
                'fr' => 'Catégorie d\'outil',
                'en' => 'Tool category',
                'de' => 'Kategorie des Werkzeugs',
                'es' => 'Categoría de herramientas',
            ],
            'Prénom' =>   [
                'fr' => 'Prénom',
                'en' => 'Firstname',
                'de' => 'Vorname',
                'es' => 'Nombre',
            ],
            'Nom' =>   [
                'fr' => 'Nom',
                'en' => 'Lastname',
                'de' => 'Nachname',
                'es' => 'Apellido',
            ],
            'Fonction' =>   [
                'fr' => 'Fonction',
                'en' => 'Function',
                'de' => 'Funktion',
                'es' => 'Función',
            ],
            'Téléphone' =>   [
                'fr' => 'Téléphone',
                'en' => 'Phone',
                'de' => 'Telefon',
                'es' => 'Teléfono',
            ],
            'Localisation' =>   [
                'fr' => 'Localisation',
                'en' => 'Location',
                'de' => 'Lokalisierung',
                'es' => 'Ubicación',
            ],
            'Responsable' =>   [
                'fr' => 'Responsable',
                'en' => 'Manager',
                'de' => 'Leiterin',
                'es' => 'Responsable de',
            ],
            'Accès rapides' =>   [
                'fr' => 'Accès rapides',
                'en' => 'Quick access',
                'de' => 'Schneller Zugriff',
                'es' => 'Acceso rápido',
            ],
            'Compte de maintenance ?' =>   [
                'fr' => 'Compte de maintenance ?',
                'en' => 'Maintenance account ?',
                'de' => 'Wartungskonto?',
                'es' => '¿Cuenta de mantenimiento?',
            ],
        ];

        foreach ($contentTypes as $machineName => $translationNameContentType) {
            $bridgeType->contentTypeUpdate($machineName, $translationNameContentType);
            foreach (InsideSchema::getDisplayedFieldListing($machineName) as $fieldName) {
                $fieldOptions = InsideSchema::getFieldOptions($machineName, $fieldName);
                foreach ($translation as $key => $trads) {
                    foreach ($trads as $langcode => $trad) {
                        if ($fieldOptions['title']['fr'] === \Illuminate\Support\Str::lower($key)) {
                            $bridgeType->changeFieldTitle($machineName, $fieldName, [$langcode => $trad]);
                        }
                    }
                }
            }
        }
    }

    public function down(): void
    {
    }
}
