<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'news_speak',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => true,
        'permissible' => true,
        'categorizable' => false,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'On parle de nous',
            'en' => 'We\'re talking about us',
            'de' => 'Man spricht über uns',
            'es' => 'Se habla de nosotros',
        ],
    ],
    'fields' => [
        [
            'name' => 'news_speak_categories',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 3,
            'title' => [
                'fr' => 'Catégorie On parle de nous',
                'en' => 'Category We\'re talking about us',
                'de' => 'Kategorie Über uns wird gesprochen',
                'es' => 'Categoría Hablamos de nosotros',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 3,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['news_speak_categories'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ],
    ],
];
