export default {
  globals: {
    calendarExportTypes: [
      {
        type: 'ics',
        label: 'iCalendar'
      }
    ]
  },
  'inside-advanced-forms': {
    extraAuthorFields: [
      {
        name: 'registration_number',
        fetch: 'registration_number',
        label: 'registrationNumber'
      }
    ]
  },
  'inside-commons': {
    banner: {
      darkMode: false
    }
  },
  'inside-comments': {
    mentionsEnabled: true
  },
  'inside-edition': {
    duplicateEnabled: true
  },
  'inside-events': {
    calendarImportEnabled: true,
    subscriptionEnabled: true
  },
  'inside-jobs': {
    extraFields: ['color', 'city'],
    categoriesFields: []
  },
  'inside-layouts': {
    firstConnectionModalEnabled: true
  },
  'inside-newcomers': {
    period: 10
  },
  'inside-news': {
    newsSuggestionEnabled: true,
    minimalDate: true
  },
  'inside-users': {
    allowAvatarEdition: false,
    modalSize: 'm',
    shortcuts: {
      max: 6
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'bookmarks', restrictions: [], icon: 'bookmark' },
        { name: 'notifications', restrictions: [], icon: 'settings' }
      ]
    },
    paragraphs: {
      fetchedContents: {
        requestFields: [
          'uuid',
          'image',
          'firstname',
          'lastname',
          'function'
        ]
      }
    }
  }
}
