import { http } from '@inside-library/helpers/Http'

export const fetchTabsSpaceCategory = async ({ $route }) => {
  try {
    const { data } = await http.get('content/tabs_spaces_categories', {
      fields: [
        'uuid',
        'admin',
        'title',
        'slug',
        'content_type',
        'introduction'
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
