import SpacesPage from '../pages/spaces/SpacesPage'
import SpacesPagesPage from '../pages/spaces/SpacesPagesPage'
import { fetchSpacesPage, fetchSpacesPagesPage } from '../components/spaces'

import TabsSpacesCategoryPage from '../pages/tabs-spaces/TabsSpacesCategoryPage'
import { fetchTabsSpaceCategory } from '../components/tabs-spaces'

import OperatingInformationPage from '../pages/operating-information/OperatingInformationPage'
import { fetchOperatingInformationPage } from '../components/operating-information'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/directory/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false
    }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1
      }
    }
  },
  {
    name: 'SpacesPage',
    path: '/espaces/:slug',
    component: withFetch(SpacesPage, { size: 'xxl' })(fetchSpacesPage)
  },
  {
    name: 'SpacesPagesPage',
    path: '/espaces/:slug/pages',
    component: withFetch(SpacesPagesPage, { size: 'xxl' })(fetchSpacesPagesPage)
  },
  {
    name: 'TabsSpacesListingPage',
    path: '/espaces-onglets',
    component: () => import('../pages/tabs-spaces/TabsSpacesListingPage')
  },
  {
    name: 'TabsSpacesCategoryPage',
    path: '/espaces-onglets/categorie/:slug',
    component: withFetch(TabsSpacesCategoryPage, { size: 'xxl' })(
      fetchTabsSpaceCategory
    )
  },
  {
    name: 'TabsSpacePage',
    path: '/espaces-onglets/:slug',
    props: {
      bannerData: {
        add: ['tabs', 'tabs_pages']
      }
    },
    meta: {
      disabled: false
    }
  },
  {
    name: 'JobsListingPage',
    component: () => import('../pages/jobs/JobsListingPage')
  },
  {
    name: 'OperatingInformationPage',
    path: '/informations-exploitation',
    component: withFetch(OperatingInformationPage, { size: 'xxl' })(
      fetchOperatingInformationPage
    )
  },
  {
    name: 'OperatingInformationDutyPage',
    path: '/informations-astreintes',
    component: withFetch(OperatingInformationPage, { size: 'xxl' })(
      fetchOperatingInformationPage
    )
  },
  {
    name: 'PlanningsPage',
    path: '/mes-plannings',
    component: () => import('../pages/plannings/PlanningsPage')
  },
  {
    name: 'FAQListingPage',
    meta: { disabled: false }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'AdminAdvancedSettingsWeatherPage',
    meta: { admin: true, display: true }
  }
]
