import { http } from '@inside-library/helpers/Http'

export default {
  spaces: {
    add: async ({ data }) => {
      const { data: spaces } = await http.get('content/spaces', {
        fields: ['uuid', 'title', 'slug'],
        filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
      })

      return {
        name: 'SpacesPage',
        params: {
          slug: spaces?.[0]?.slug?.[0]
        }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: spaces } = await http.get('content/spaces', {
        fields: ['uuid', 'title', 'slug'],
        filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
      })

      return {
        route: {
          name: 'SpacesPage',
          params: {
            slug: spaces?.[0]?.slug?.[0]
          }
        }
      }
    }
  },
  pagesCategories: {
    add: async ({ data }) => {
      const { data: category } = await http.get('content/pages_categories', {
        fields: ['uuid', { spaces: { fields: ['slug'] } }],
        filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
      })

      return {
        name: 'SpacesPage',
        params: {
          slug: category?.[0].spaces?.slug?.[0]
        },
        query: {
          tab: data.uuid
        }
      }
    },
    delete: async ({ uuid }) => {
      const { data: category } = await http.get('content/pages_categories', {
        fields: ['uuid', { spaces: ['slug'] }],
        filters: { 'status:eq': 1, 'uuid:eq': uuid }
      })

      return {
        name: 'SpacesPage',
        params: {
          slug: category?.[0].spaces?.slug?.[0]
        }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: pagesCategories } = await http.get(
        'content/pages_categories',
        {
          fields: ['uuid', { spaces: ['slug'] }],
          filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
        }
      )

      return {
        route: {
          name: 'SpacesPagesPage',
          params: {
            slug: pagesCategories[0].spaces.slug[0]
          }
        }
      }
    }
  },
  spacesPages: {
    add: async ({ data }) => {
      const { data: spacesPage } = await http.get('content/spaces_pages', {
        fields: [
          {
            pages_categories: [{ spaces: { fields: ['slug'] } }]
          }
        ],
        filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
      })

      return {
        name: 'SpacesPagesPage',
        params: {
          slug: spacesPage?.[0].pages_categories?.spaces?.slug?.[0]
        },
        query: { page: data.uuid }
      }
    },
    delete: async ({ uuid }) => {
      const { data: spacesPage } = await http.get('content/spaces_pages', {
        fields: [
          {
            pages_categories: [{ spaces: { fields: ['slug'] } }]
          }
        ],
        filters: { 'status:eq': 1, 'uuid:eq': uuid }
      })

      return {
        name: 'SpacesPagesPage',
        params: {
          slug: spacesPage?.[0].pages_categories?.spaces?.slug?.[0]
        }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: pagesCategories } = await http.get('content/spaces_pages', {
        fields: [
          'uuid',
          { pages_categories: ['uuid', { spaces: { fields: ['slug'] } }] }
        ],
        filters: { 'uuid:eq': data.uuid }
      })

      return {
        route: {
          name: 'SpacesPagesPage',
          params: {
            slug: pagesCategories?.[0].pages_categories?.spaces?.slug?.[0]
          },
          query: { page: data.uuid }
        }
      }
    }
  },
  tabsSpaces: {
    add: async ({ data }) => {
      try {
        const { data: space } = await http.get('content/tabs_spaces', {
          fields: ['slug'],
          filters: {
            'uuid:eq': data.uuid
          }
        })

        return {
          name: 'TabsSpacePage',
          params: {
            slug: space[0]?.slug[0]
          }
        }
      } catch (err) {
        throw new Error(err)
      }
    },
    delete: () => ({
      name: 'TabsSpacesListingPage'
    })
  },
  tabs: {
    add: async ({ data }) => {
      try {
        const { data: tab } = await http.get('content/tabs', {
          fields: [{ tabs_spaces: ['slug'] }],
          filters: {
            'uuid:eq': data.uuid
          }
        })

        return {
          name: 'TabsSpacePage',
          params: {
            slug: tab[0]?.tabs_spaces?.slug[0]
          }
        }
      } catch (err) {
        throw new Error(err)
      }
    },
    delete: async ({ data }) => {
      try {
        const { data: tab } = await http.get('content/tabs', {
          fields: [{ tabs_spaces: ['slug'] }],
          filters: {
            'uuid:eq': data.uuid
          }
        })

        return {
          name: 'TabsSpacePage',
          params: {
            slug: tab[0]?.tabs_spaces?.slug[0]
          }
        }
      } catch (err) {
        throw new Error(err)
      }
    }
  },
  tabsPages: {
    add: async ({ data }) => {
      try {
        const { data: page } = await http.get('content/tabs_pages', {
          fields: [
            'uuid',
            {
              tabs: ['uuid', { tabs_spaces: ['slug'] }]
            }
          ],
          filters: {
            'uuid:eq': data.uuid
          }
        })

        return {
          name: 'TabsSpacePage',
          params: {
            slug: page[0]?.tabs?.tabs_spaces?.slug[0]
          },
          query: { page: data.uuid }
        }
      } catch (err) {
        throw new Error(err)
      }
    },
    delete: async ({ data }) => {
      try {
        const { data: page } = await http.get('content/tabs_pages', {
          fields: [
            'uuid',
            {
              tabs: ['uuid', { tabs_spaces: ['slug'] }]
            }
          ],
          filters: {
            'uuid:eq': data.uuid
          }
        })

        return {
          name: 'TabsSpacePage',
          params: {
            slug: page[0]?.tabs.tabs_spaces?.slug[0]
          }
        }
      } catch (err) {
        throw new Error(err)
      }
    }
  },
  tabsSpacesCategories: {
    add: async ({ data }) => {
      try {
        const { data: category } = await http.get('content/tabs_spaces_categories', {
          fields: [
            'uuid',
            'slug'
          ],
          filters: {
            'uuid:eq': data.uuid
          }
        })

        return {
          name: 'TabsSpacesCategoryPage',
          params: {
            slug: category[0]?.slug[0]
          }
        }
      } catch (err) {
        throw new Error(err)
      }
    },
    delete: () => ({
      name: 'TabsSpacesListingPage'
    }),
    globalSearch: async ({ data }) => {
      const { data: categories } = await http.get('content/tabs_spaces_categories', {
        fields: [
          'uuid',
          'slug'
        ],
        filters: { 'uuid:eq': data.uuid }
      })

      return {
        route: {
          name: 'TabsSpacesCategoryPage',
          params: {
            slug: categories?.[0]?.slug?.[0]
          }
        }
      }
    }
  },
  blockSpaces: {
    add: () => ({
      name: 'HomePage'
    }),
    delete: () => ({
      name: 'HomePage'
    })
  }
}
