<?php

use Illuminate\Support\Facades\Route;
use Inside\Content\Http\Controllers\External\Index as ExternalIndex;

Route::group(
    [
        'namespace' => 'Inside\SETE\Http\Controllers',
        'prefix' => 'api/v1/sete',
        'middleware' => ['auth.api'],
    ],
    function ($router) {
        $router->get('page/{pageName}', ['uses' => 'EiffelPagesController@index']);
        $router->get('planning', ['uses' => 'EiffelPlanningController@index']);
    }
);

Route::group(
    [
        'namespace' => 'Inside\SETE\Http\Controllers',
        'prefix' => 'api/v1/sete'
    ],
    function ($router) {
        $router->get('download/{sheet}', ['uses' => 'EiffelSheetsController@index']);
    }
);

Route::group(
    [
        'namespace' => 'Inside\SETE\Http\Controllers',
        'prefix' => 'api/v1',
        'middleware' => ['auth.external:sete_external_api'],
    ],
    function ($router) {
        $router->get('external/resource/{path:.*}', ['uses' => 'ExternalApiController@getResource']);
    }
);

Route::group(
    [
        'prefix' => 'api/v1',
        'middleware' => ['auth.external:sete_external_api'],
    ],
    function ($router) {
        $router->get('external/{type:'.get_authorized_external_api_content_types().'}', ExternalIndex::class);
    }
);
