<?php

namespace Inside\SETE\Services;

use GuzzleHttp\Client;
use Inside\Content\Models\Contents\InfosKeys;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class InfoKeysService
{
    private const INFOS_KEYS = 'infos_keys';
    private const CONTENT_LABEL = 'visiteurs';

    private const VISITEURS = 'visiteurs';
    private const VISITEURS_CUMULES = 'visiteurs_cumul';


    private const ACTIONS = [
      self::VISITEURS,
      self::VISITEURS_CUMULES
    ];

    private BridgeContent $bridgeContent;

    private array $apiValues = [
        self::VISITEURS => "",
        self::VISITEURS_CUMULES => ""
    ];

    public function __construct(
        private EiffelApiService $eiffelApiService
    ) {
        $this->bridgeContent = new BridgeContent();
    }

    public function execute(): void
    {
        collect(self::ACTIONS)
          ->each(fn (string $action) => $this->loadApiValues($action));

        $this->createOrUpdateInfoKeys();
    }

    private function loadApiValues(string $action): void
    {
        $infoKeyData = json_decode($this->eiffelApiService->getAction($action)->content(), true);
        $this->apiValues[$action] = $infoKeyData['response'] ?? "";
    }

    private function createOrUpdateInfoKeys(): void
    {
        $hasEmptyValue = collect($this->apiValues)->filter()->isEmpty();

        if ($hasEmptyValue) {
            return;
        }

        $infoKeyModels = InfosKeys::query()
            ->where('action_label', self::CONTENT_LABEL)
            ->first();

        empty($infoKeyModels) ?
          $this->createInfoKey() :
          $this->updateInfoKey($infoKeyModels->uuid);
    }

    private function createInfoKey(): void
    {
        $content = config('info_key.visiteurs');
        $content['metric'] = $this->apiValues['visiteurs'];
        $this->bridgeContent->contentInsert(self::INFOS_KEYS, $content);
    }

    private function updateInfoKey(string $infosKeyUuid): void
    {
        $visitorsCumulus = $this->apiValues['visiteurs_cumul'];
        $content = [
            'uuid' => $infosKeyUuid,
            'metric' => $this->apiValues['visiteurs'],
            'cumul_year' => sprintf("%s : %s", $visitorsCumulus['Y'], $visitorsCumulus['cumul_Y']),
            'cumul_past_year' => sprintf("%s : %s", $visitorsCumulus['Y-1'], $visitorsCumulus['cumul_Y-1'])
        ];

        $this->bridgeContent->contentUpdate(self::INFOS_KEYS, $content, true);
    }
}
