<?php

namespace Inside\SETE\Services;

use Illuminate\Http\JsonResponse;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;
use Inside\Authentication\Models\User;
use Inside\SETE\Exceptions\EiffelPlanningException;

class EiffelPlanningService
{
    private string $date;
    private bool $payPlanning;
    private string $cacheKey;
    private string $matricule;

    public function __construct(
        private EiffelApiService $eiffelApiService,
    ) {
    }

    public function getResponse(): JsonResponse
    {
        /** @var ?User $user */
        $user = Auth::user();

        $this->date = Carbon::parse(request('date', now()->toIso8601String()))->format('Y-m-d');
        $this->payPlanning = request('pay_planning', 'false') === 'true';
        $this->matricule = $user?->information?->registration_number ?? '';
        if (blank($this->matricule)) {
            return response()->json([
                "error" => "Matricule not found or invalid"
            ], 400);
        }

        $this->cacheKey =  sprintf("%s_%s_%s", $this->matricule, $this->date, request('pay_planning', 'false'));
        $cachedData = Cache::tags(['sete_individual_planning'])->get($this->cacheKey);
        if (!empty($cachedData)) {
            return $cachedData;
        }

        return $this->fetchPageData();
    }

    private function fetchPageData(): JsonResponse
    {
        $fetchedPageData = $this->eiffelApiService->setMatricule($this->matricule);
        if ($this->payPlanning) {
            $fetchedPageData->addExtraParameter('format20', '1');
        }
        $fetchedPageData = $fetchedPageData->getAction(action: 'planning_individuel', date: $this->date);

        Cache::tags(['sete_individual_planning'])->put(
            $this->cacheKey,
            $fetchedPageData,
            config('api_eiffel.cache.expiration')
        );

        return $fetchedPageData;
    }
}
