<?php

namespace Inside\SETE\Http\Controllers;

use Illuminate\Support\Carbon;
use Inside\SETE\Exceptions\SheetDownloadException;
use Symfony\Component\HttpFoundation\StreamedResponse;
use Inside\SETE\Services\EiffelApiService;
use Laravel\Lumen\Routing\Controller;

class EiffelSheetsController extends Controller
{
    private const SHEETS = [
        'fj_accueil',
        'fj_caisses',
        'fj_aes'
    ];

    private const MAX_DAYS_AHEAD = 4;

    public function __construct(private EiffelApiService $eiffelApiService)
    {
    }

    public function index(string $sheet): StreamedResponse
    {
        if (!in_array($sheet, self::SHEETS)) {
            abort(404, 'Sheet Not found');
        }

        $date = Carbon::parse(request('date', now()->toIso8601String()));
        $maxDate = now()->addDays(self::MAX_DAYS_AHEAD)->startOfDay();

        if ($date->gt($maxDate)) {
            throw new SheetDownloadException(
                sprintf('Le fichier demandé n\'est pas disponible')
            );
        }

        return $this->eiffelApiService
            ->downloadFile($sheet, $date->format('Y-m-d'));
    }
}
