<?php

namespace Inside\SETE\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Inside\SETE\Services\EiffelPageService;
use Laravel\Lumen\Routing\Controller;

class EiffelPagesController extends Controller
{
    private const PAGES = [
        'realtimeinfo',
        'planning'
    ];

    public function __construct(private EiffelPageService $eiffelPageService)
    {
    }

    public function index(string $pageName): JsonResponse
    {
        if (!in_array($pageName, self::PAGES)) {
            abort(404, 'Page Not found');
        }

        $date = request('date', now()->toIso8601String());
        $response = $this->eiffelPageService
            ->setPage($pageName)
            ->setDate($date)
            ->execute();

        return response()->json($response);
    }
}
