<?php

namespace Inside\SETE\Console;

use Illuminate\Console\Command;
use Inside\SETE\Services\InfoKeysService;

/**
 * Class UpdateInfoKeysCommand
 *
 * @category Class
 * @package  Inside\SETE\Console\UpdateInfoKeysCommand
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class UpdateInfoKeysCommand extends Command
{
    protected $name = 'update:info-keys';

    /**
     * @var string
     */
    protected $signature = 'update:info-keys';

    /**
     * @var string
     */
    protected $description = 'Update info keys from API';


    public function __construct(
        private InfoKeysService $infoKeysService
    ) {
        parent::__construct();
    }

    public function handle(): void
    {
        $this->info('[Update info key] : Start update infos keys');
        $this->line('');
        $this->infoKeysService->execute();
        $this->line('[Update info key] : End update infos keys');
    }
}
