<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Bridge\BridgeContent;

class AddDarkModeToInfoKeys extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            type: 'infos_keys',
            fieldName: 'dark_mode',
            options : [
                'name' => 'dark_mode',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'search_filter' => false,
                'required' => false,
                'weight' => 5,
                'title' => [
                    'fr' => 'Mode sombre',
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                        'display_label' => true,
                    ],
                    'weight' => 5,
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
                'default' => false,
            ]
        );

        Artisan::call('models:rebuild');

        $bridgeContent = new BridgeContent();

        type_to_class('infos_keys')::each(
            fn ($infoKey) => $bridgeContent->contentUpdate('infos_keys', [
                'uuid' => $infoKey->uuid,
                'dark_mode' => false,
            ])
        );
    }
}
