<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Database\Eloquent\Builder;
use Inside\Host\Bridge\BridgeContent;

class AddCustomPageInfoCod extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();

        /** @var Builder $query */
        $query = type_to_class('custom')::query()->where('redirection_page', 'OperatingInformationDutyPage');

        if ($query->doesntExist()) {
            $bridge->contentInsert(
                type: 'custom',
                data: [
                    'type' => 'node',
                    'bundle' => 'custom',
                    'title' => 'Informations Astreinte',
                    'custom_slug' => 'operating-information-duty',
                    'redirection_page' => 'OperatingInformationDutyPage',
                    'langcode' => 'fr',
                    'status' => true,
                ],
                creation: true,
                fromCli: false
            );
        }
    }
}
