<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;

class AddCumulToInfoKeys extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $fields = [
          'cumul_year' => "Année en cours",
          'cumul_past_year' => "Année passée",
        ];

        collect($fields)->each(
            fn ($title, $fieldName) => $bridge->contentTypeCreateOrUpdateField(
                type: 'infos_keys',
                fieldName: $fieldName,
                options : [
                    'name' => $fieldName,
                    'searchable' => false,
                    'translatable' => false,
                    'search_result_field' => false,
                    'searchable_filter' => false,
                    'required' => false,
                    'weight' => 4,
                    'title' => [
                        'fr' => $title,
                    ],
                    'widget'       => [
                        'type'     => BridgeContentType::TEXT_WIDGET,
                        'settings' => [],
                    ],
                    'type'         => BridgeContentType::TEXT_FIELD,
                    'settings' => [
                        'case_sensitive' => false,
                        'cardinality' => 1,
                    ],
                ]
            )
        );
        Artisan::call('models:rebuild');
    }
}
