<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\ContentBlueprints;
use Inside\Host\Bridge\BridgeContentType;

class AddCodeToInfoKeys extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'infos_keys',
            'action_label',
            [
              'name' => 'action_label',
              'searchable' => false,
              'translatable' => true,
              'search_result_field' => false,
              'searchable_filter' => false,
              'required' => true,
              'weight' => 4,
              'title' => [
                'fr' => 'Label action',
              ],
              'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                  'size' => 60,
                  'placeholder' => '',
                ],
                'weight' => 4,
              ],
              'type' => BridgeContentType::TEXT_FIELD,
              'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
              ],
            ]
        );
    }
}
