<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'jobs_offers',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => false,
        'permissible' => false,
        'categorizable' => true,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Offre d\'emploi',
        ],
    ],
    'fields' => [
        [
            'name' => 'color',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Couleur',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_COLOR_PICKER_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'contracts_types',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 1,
            'title' => [
                'fr' => 'Type de contrat',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['contracts_types'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ],
        [
            'name' => 'content',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 2,
            'title' => [
                'fr' => 'Contenu',
            ],
            'widget' => [
                'type' => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title' => 'Paragraphe',
                    'title_plural' => 'Paragraphes',
                    'edit_mode' => 'open',
                    'add_mode' => 'dropdown',
                    'form_display_mode' => 'default',
                    'default_paragraph_type' => '',
                ],
                'weight' => 2,
            ],
            'type' => BridgeContentType::SECTION_FIELD,
            'settings' => [
                'target_type' => [
                    'text',
                    'text_two_columns',
                    'text_with_image',
                    'separator',
                    'file',
                    'slider',
                    'image',
                    'video',
                    'map',
                    'accordion',
                    'call_to_action',
                    'button',
                    'html',
                    'tweet',
                    'fetched_contents',
                ],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'city',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Ville',
            ],
            'widget'       => [
                'type'     => BridgeContentType::TEXT_WIDGET,
                'settings' => [],
            ],
            'type'         => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ]
    ],
];
