<?php

return [
    'manual_notifications' => [
        'enabled' => true,
        'enhanced_notifications' => true,
        'enhanced_notifications_types_and_fields' => [
            'news' => [
                'fields' => [
                    'image',
                    'chapo',
                ]
            ],
            'events' => [
                'fields' => [
                    'image',
                    'chapo',
                ]
            ]
        ],
        'enabled_types' => [
            'news',
            'events',
            'documents',
            'flash_news',
            'jobs_offers',
        ],
        'custom_url' => fn (string $channel, string $type, string $id) => match ($type) {
            'jobs_offers' => 'CUSTOM:jobs_offers',
            'flash_news' => 'CUSTOM:slugless',
            default => null,
        },
    ],
    'build_url_callbacks' => [
        'jobs_offers' => function ($model) {
            return "offres-emploi?modal=job&contentType=jobs_offers&uuid=$model->uuid&size=m";
        },
        'slugless' => fn ($model) => url('/')
    ],
];
