<?php

use Illuminate\Support\Arr;
use Inside\Content\Facades\ContentHelper;
use Illuminate\Support\Facades\Schema;

if (! function_exists('clean_content_types')) {
    function clean_content_types(array $content): array
    {
        return Arr::except(
            $content,
            config('external_api.inside_external_api_fields_content_remove')
        );
    }
}

return [
    'inside_external_api_enabled' => env('INSIDE_EXTERNAL_API_ENABLED', true),
    'inside_external_api_bypass_auth_external' => env('INSIDE_EXTERNAL_API_AUTH_BYPASS', true),
    'inside_external_api_pagination_limit' => 50,
    'inside_external_api_fields' => [
        'flash_news' => [
            'uuid',
            'title',
            'flash_content',
            'updated_at',
            'published_at',
            'slug',
        ],
        'news' => [
            'uuid',
            'content_type',
            'title',
            'news_categories'  => ['title'],
            'chapo',
            'image',
            'content',
            'updated_at',
            'published_at',
            'slug',
            'is_featured',
        ],
        'events' => [
            'uuid',
            'content_type',
            'title',
            'events_categories'  => ['title'],
            'date',
            'end_date',
            'time',
            'place',
            'participants_number',
            'registration_enabled',
            'expired',
            'image',
            'content',
            'updated_at',
            'published_at',
            'slug',
        ],
    ],
    'inside_external_api_fields_content_remove' => [
        'uuid',
        'created_at',
        'updated_at',
        'reactions',
        'published_at',
        'statistics',
        'unique_views',
        'total_views',
        'archived',
        'description',
    ],
    'inside_external_api_filters' => function ($query, $request) {
        $query->where('status', 1);
        if ($request->has('langcode')) {
            $query->where('langcode', $request->get('langcode'));
        }
        if ($request->has('updated_at')) {
            $timestamp = $request->get('updated_at');
            $query->where('updated_at', '>=', date('Y-m-d H:i:s', $timestamp));
        }

        $queryTable = (string) $query->getModel()->getTable();
        if ($queryTable === type_to_table('flash_news') && Schema::hasColumn($queryTable, 'end_date')) {
            $query->where('end_date', '>', now());
        }

        $query->orderBy('published_at', 'desc');
        return $query;
    },
    'inside_external_api_transform' => function ($result) {
        $result->transform(function ($data) {
            if (isset($data['content'])) {
                $data['content'] = collect($data['content'])->transform(
                    fn ($content) => isset($content['content']) ?
                  collect($content['content'])
                    ->transform(fn ($content) => clean_content_types($content))
                    ->filter()
                    ->toArray()
                  : clean_content_types($content)
                )->filter()->toArray();
            }
            if (isset($data['image'])) {
                $data['image'] = sprintf(
                    "%s/notify_content_files/%s/%s",
                    config('app.url'),
                    $data['content_type'],
                    $data['uuid']
                );
                unset($data['content_type']);
            }
            if (array_key_exists('expired', $data)) {
                $data['expired'] = !empty($data['end_date']) && get_date_in_user_timezone($data['end_date'])?->isBefore(now());
            }
            if (array_key_exists('time', $data)) {
                $data['time'] = get_date_in_user_timezone($data['date'])?->toTimeString();
            }
            if (! isset($data['content'])) {
                $data['content'] = [];
            }

            return $data;
        })->toArray();

        return $result;
    },
];
