<?php

namespace Inside\SETE\Providers;

use Inside\Providers\ServiceProvider as BaseServiceProvider;
use Inside\SETE\Console\UpdateInfoKeysCommand;
use Inside\SETE\Services\EiffelApiService;
use Inside\SETE\Services\InfoKeysService;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

/**
 * SETE Service provider.
 *
 * @category Class
 * @package  Inside\\SETE\Providers\ServiceProvider
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ServiceProvider extends BaseServiceProvider
{
    /**
     * Boot
     */
    public function boot(): void
    {
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');
    }

    /**
     * Register
     */
    public function register(): void
    {
        try {
            $this->app->singleton(EiffelApiService::class, function () {
                return new EiffelApiService(
                    config('api_eiffel.base_uri'),
                    config('api_eiffel.user'),
                    config('api_eiffel.matricule'),
                    config('api_eiffel.api_password'),
                    config('api_eiffel.cert_pem'),
                    config('api_eiffel.key_pem'),
                    config('api_eiffel.cert_password'),
                );
            });
            if ($this->app->runningInConsole()) {
                $this->app->singleton(
                    'command.update.info-keys',
                    function ($app) {
                        return new UpdateInfoKeysCommand(
                            $app->make(InfoKeysService::class)
                        );
                    }
                );
                $this->commands('command.update.info-keys');
            }

            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/scheduler.php', 'scheduler');
            $this->mergeConfigTo(__DIR__.'/../../config/notify.php', 'notify');
            $this->mergeConfigTo(__DIR__.'/../../config/azuread.php', 'azuread');
            $this->mergeConfigTo(__DIR__.'/../../config/api_eiffel.php', 'api_eiffel');
            $this->mergeConfigTo(__DIR__.'/../../config/info_key.php', 'info_key');
            $this->mergeConfigTo(__DIR__.'/../../config/exploitation.php', 'exploitation');
            $this->mergeConfigTo(__DIR__.'/../../config/statistics.php', 'statistics');
            $this->mergeConfigTo(__DIR__.'/../../config/form.php', 'form');
            $this->mergeConfigTo(__DIR__.'/../../config/external_api.php', 'external_api');
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }
    }
}
