<?php

namespace Inside\SETE\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Inside\Content\Models\Contents\Jobs;
use Laravel\Lumen\Routing\Controller;
use Symfony\Component\HttpFoundation\Response;

class ExternalApiController extends Controller
{
    public function getResource(Request $request, string $path): Response | JsonResponse
    {
        preg_match('/\/file\/(\d{4}-\d{2}).*/', $path, $matches);
        $filePath = preg_replace('/\/file/', '', $matches[0]);
        $filePath = urldecode($filePath);
        if (! Storage::exists($filePath)) {
            return new JsonResponse(['message' => 'File not found !'], 404);
        }

        return $this->getFileFromStorage($filePath);
    }

    private function getFileFromStorage(string $filePath): Response
    {
        $path = Storage::path($filePath);
        /** @var string $file */
        $file = file_get_contents($path);
        /** @var array $pathinfo */
        $pathinfo = pathinfo($path);
        $extension = $pathinfo['extension'];

        switch ($extension) {
            case 'gif':
                $type = 'image/gif';
                break;
            case 'png':
                $type = 'image/png';
                break;
            case 'jpeg':
            case 'jpg':
                $type = 'image/jpeg';
                break;
            case 'mp4':
                $type = 'video/mp4';
                break;
            case 'pdf':
                $type = 'application/pdf';
                break;
            default:
                return new JsonResponse(['message' => 'File not found !'], 404);
        }

        return new Response($file, 200, ['Content-type' => $type]);
    }
}
