<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Models\Contents\AdvancedForms;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class SeteRenameDescriptionField extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'advanced_forms',
            'advanced_forms_description',
            [
                'type'                => BridgeContentType::WYSIWYG_FIELD,
                'name'                => 'advanced_forms_description',
                'searchable'          => false,
                'translatable'        => true,
                'search_result_field' => false,
                'required'            => false,
                'weight'              => 0,
                'default'             => false,
                'title'               => [
                    'fr' => 'Description',
                    'en' => 'Description',
                    'nl' => 'Beschrijving',
                    'de' => 'Beschreibung',
                    'es' => 'Descripción',
                    'pt' => 'Descrição',
                ],
                'description'         => [
                    'fr' => 'Description du formulaire',
                    'en' => 'Description of the form',
                    'nl' => 'Beschrijving van het formulier',
                    'de' => 'Beschreibung des Formulars',
                    'es' => 'Descripción del formulario',
                    'pt' => 'Descrição do formulário',
                ],
                'settings'            => [],
                'widget'              => [
                    'type'     => BridgeContentType::WYSIWYG_WIDGET,
                    'settings' => [],
                ],
            ],
            4
        );

        Artisan::call('models:rebuild');
        $bridgeContent = new BridgeContent();

        AdvancedForms::whereNotNull('description')->select('description', 'uuid')->get()->each(
            fn ($form) => $bridgeContent->contentUpdate('advanced_forms', [
                'uuid' => $form->uuid,
                'advanced_forms_description' => $form->description
            ])
        );

        $bridge->contentTypeDeleteField('node', 'advanced_forms', 'description');

        Artisan::call('models:rebuild');
    }
}
