<?php

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Content;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class MigrateToConnexionPopupsType extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $bridge = new BridgeContent();

        /** @var Builder $query */
        $query = type_to_class('popins')::query();

        $query->get()->each(function (Content $popins) use ($bridge) {
            $attributes = $popins->getAttributes();
            $data = [
                'title' => $attributes['title'],
                'status' => $attributes['status'],
                'created_at' => $attributes['created_at'],
                'updated_at' => $attributes['updated_at'],
                'published_at' => $attributes['published_at'],
            ];

            $content = collect(get_content_sections($popins))->map(
                fn ($section) => collect($section)
                ->except(['uuid', 'uuid_host'])
                ->put('pgID', '_fresh')
                ->toArray()
            )->toArray();

            $uuid = $bridge->contentInsert('connexion_popups', $data, true, true);
            $bridge->contentUpdate('connexion_popups', ['uuid' => $uuid, 'content' => $content], true);
        });

        $bridgeContentType = new BridgeContentType();
        $bridgeContentType->contentTypeDelete('popins');
    }
}
