<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Models\Contents\InfosKeys;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class SwitchInfosKeysTextToWw extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'infos_keys',
            'text',
            [
                'name' => 'text',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'search_filter' => false,
                'required' => false,
                'weight' => 4,
                'title' => [
                    'fr' => 'Texte',
                ],
                'widget' => [
                    'type' => BridgeContentType::WYSIWYG_WIDGET,
                    'settings' => [],
                    'weight' => 1,
                ],
                'type' => BridgeContentType::WYSIWYG_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
            4
        );

        Artisan::call('models:rebuild');
        $bridgeContent = new BridgeContent();

        InfosKeys::whereNotNull('texte')->select('texte', 'uuid')->get()->each(
            fn ($info) => $bridgeContent->contentUpdate('infos_keys', [
                'uuid' => $info->uuid,
                'text' => $info->texte
            ])
        );

        $bridge->contentTypeDeleteField('node', 'infos_keys', 'texte');

        Artisan::call('models:rebuild');
    }
}
